<?php
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;


$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

do_action( 'woocommerce_before_add_to_cart_form' ); ?>
<form class="variations_form cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo $variations_attr; // WPCS: XSS ok. ?>">
    <?php do_action( 'woocommerce_before_variations_form' ); ?>

    <?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
        <p class="stock out-of-stock"><?php echo esc_html( apply_filters( 'woocommerce_out_of_stock_message', __( 'This product is currently out of stock and unavailable.', 'woocommerce' ) ) ); ?></p>
    <?php else : ?>



        <table class="variations" cellspacing="0" role="presentation">
            <tbody>
<?php
foreach ($attributes as $attribute_name => $options) {
    // دریافت شناسه ویژگی
    $attr_id = wc_attribute_taxonomy_id_by_name($attribute_name);
    // دریافت مقدار فیلد سفارشی
    $my_field = get_option("wc_attribute_my_field-$attr_id");
    ?>			
                    <tr>
                        <th class="label"><label for="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"><?php echo wc_attribute_label( $attribute_name ); // WPCS: XSS ok. ?></label></th>
        <td class="value <?php echo esc_attr($my_field); ?>">

						<?php
                                wc_dropdown_variation_attribute_options(
                                    array(
                                        'options'   => $options,
                                        'attribute' => $attribute_name,
                                        'product'   => $product,
                                    )
                                );
                            ?>



                           <?php foreach ( $options as $option ) : ?>
    <?php $term = get_term_by( 'slug', $option, $attribute_name ); ?>
    <div class="woocommerce-variation-radio">
   <input type="radio"
               name="<?php echo esc_attr( 'attribute_' . sanitize_title( $attribute_name ) ); ?>"
               value="<?php echo esc_attr( $option ); ?>"
               data-attribute_name="attribute_<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"
               data-attribute_value="<?php echo esc_attr( $option ); ?>"
               id="<?php echo esc_attr( sanitize_title( $attribute_name ) . '_' . sanitize_title( $option ) ); ?>"
               <?php checked( sanitize_title( $product->get_attribute( $attribute_name ) ), sanitize_title( $option ) ); ?>>
        <label for="<?php echo esc_attr( sanitize_title( $attribute_name ) . '_' . sanitize_title( $option ) ); ?>">
            <?php
            // بررسی اینکه آیا ویژگی سفارشی است یا از ترم‌های Taxonomy است
            $term = get_term_by( 'slug', $option, $attribute_name );
        if ( $term && ! is_wp_error( $term ) ) {
$color_value = get_term_meta( $term->term_id, '_color_attribute', true );
            if ( ! empty( $color_value ) ) {
                echo '<div class="color-badge-filter"><span style="background-color: ' . esc_attr( $color_value ) . '; display: inline-block; width: 20px; height: 20px; margin-left: 5px;"></span></div>';
            }
    echo esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name ) );
} else {
    // در صورتی که ویژگی سفارشی باشد (متنی)
    echo esc_html( $option );
}
            ?>
        </label>
        </label>
    </div>
<?php endforeach; ?>


                       <?php         echo end( $attribute_keys ) === $attribute_name ? wp_kses_post( apply_filters( 'woocommerce_reset_variations_link', '<div class="mehrnoosh-rest-radio-button"><a class="reset_variations" href="#">' . esc_html__( 'Clear', 'woocommerce' ) . '</a></div>' ) ) : '';
?>
<script>

jQuery(function($) {
    // حذف مقادیر دکمه‌های رادیویی هنگام کلیک روی reset_variations
    $('.reset_variations').on('click', function() {
        $('.woocommerce-variation-radio input[type="radio"]').prop('checked', false);
    });
});
    jQuery(function($) {
        // اگر در زمان بارگذاری صفحه select بر روی گزینه‌ای باشد، دکمه رادیو مربوطه را انتخاب کنید
        $('select').each(function() {
            var $select = $(this);
            var attribute_name = $select.attr('name');
            var attribute_value = $select.val();
            var $radio = $('.woocommerce-variation-radio input[data-attribute_name="' + attribute_name + '"][data-attribute_value="' + attribute_value + '"]');
            
            // انتخاب مقدار متناظر در دکمه رادیو
            $radio.prop('checked', true);
        });

        // بر اساس تغییر در دکمه رادیوها، مقدار منوی انتخاب کننده را تنظیم کنید
        $('.variations_form').on('change', '.woocommerce-variation-radio input', function() {
            var $radio = $(this);
            var attribute_name = $radio.data('attribute_name');
            var attribute_value = $radio.val();
            var $select = $('select[name="' + attribute_name + '"]');
   
            // انتخاب مقدار متناظر در منوی انتخاب کننده
            $select.val(attribute_value).trigger('change');
        });

        // بر اساس تغییر در منوی انتخاب کننده، دکمه رادیو مربوطه را انتخاب کنید
        $('.variations_form').on('change', 'select', function() {
            var $select = $(this);
            var attribute_name = $select.attr('name');
            var attribute_value = $select.val();
            var $radio = $('.woocommerce-variation-radio input[data-attribute_name="' + attribute_name + '"][data-attribute_value="' + attribute_value + '"]');
   
            // انتخاب مقدار متناظر در دکمه رادیو
            $radio.prop('checked', true);
        });
    });
</script>
                        </td>
                    </tr>
<?php } ?>            </tbody>
        </table>
        <?php do_action( 'woocommerce_after_variations_table' ); ?>

        <div class="single_variation_wrap">
            <?php
                /**
                 * Hook: woocommerce_before_single_variation.
                 */
                do_action( 'woocommerce_before_single_variation' );

                /**
                 * Hook: woocommerce_single_variation. Used to output the cart button and placeholder for variation data.
                 *
                 * @since 2.4.0
                 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
                 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
                 */
                do_action( 'woocommerce_single_variation' );

                /**
                 * Hook: woocommerce_after_single_variation.
                 */
                do_action( 'woocommerce_after_single_variation' );
            ?>
        </div>
    <?php endif; ?>

    <?php do_action( 'woocommerce_after_variations_form' ); ?>
</form>

<?php
do_action( 'woocommerce_after_add_to_cart_form' );
