<?php
/**

 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<p class="ligin"><?php
	/* translators: 1: user display name 2: logout url */
	printf(
		__( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ),
		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
		esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
	);
?></p>


 <?php if((get_option('acc1') == true )): ?>

<div class="ete">

<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21">
<i class="mdi mdi-basket"></i>
</div>
<div class="disk-1">

<h2>محصولات خریداری شده

</h2>

<div class="boete1"><?php echo number_format( count( es_get_customer_bought_products() ) ); ?></div>
</div></div></div>


<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21" style="background: linear-gradient(180deg,#fecf6c,#ffbe70);box-shadow: rgba(254,206,108,.65) 0 2px 15px;">
<i class="mdi mdi-card-bulleted-outline"></i>

</div>
<div class="disk-1">
<h2>مبلغ سفارشات شما

</h2>

<div class="boete1"><?php echo wc_price( es_get_customer_total_order() ); ?></div>

</div></div>
</div>

<div class="user-a">
<div class="user-a-1">
<div class="iconuser r-21" style="background: linear-gradient(180deg,#aae181,#89d351);box-shadow: rgba(137,211,81,.43) 0 2px 15px;">
<i class="mdi mdi-comment-processing-outline"></i>

</div>
<div class="disk-1">

<h2>کل دیدگاه ها

</h2>

<div class="boete1"><?php echo es_comment_count( get_current_user_id() ); ?></div>

</div></div></div>

</div>	
	<?php endif; ?>
	
	
<div class="sepid-sefaresh">
<div class="sepid-sefaresh1">
<?php
/**
 * My Orders - Deprecated
 *
 * @deprecated 2.6.0 this template file is no longer used. My Account shortcode uses orders.php.
 * @package WooCommerce\Templates
 */

defined( 'ABSPATH' ) || exit;

$my_orders_columns = apply_filters(
	'woocommerce_my_account_my_orders_columns',
	array(
		'order-number'  => esc_html__( 'Order', 'woocommerce' ),
		'order-date'    => esc_html__( 'Date', 'woocommerce' ),
		'order-status'  => esc_html__( 'Status', 'woocommerce' ),
		'order-total'   => esc_html__( 'Total', 'woocommerce' ),
		'order-actions' =>  esc_html__( 'نمایش', 'woocommerce' ),
	)
);

$customer_orders = get_posts(
	apply_filters(
		'woocommerce_my_account_my_orders_query',
		array(
			'numberposts' => 6,
			'meta_key'    => '_customer_user',
			'meta_value'  => get_current_user_id(),
			'post_type'   => wc_get_order_types( 'view-orders' ),
			'post_status' => array_keys( wc_get_order_statuses() ),
		)
	)
);

if ( $customer_orders ) : ?>
<div class="elkone  sef-435345">
<h3 class="title-2 sef754343">

<?php echo apply_filters( 'woocommerce_my_account_my_orders_title', esc_html__( 'Recent orders', 'woocommerce' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?> <a href="<?php echo get_permalink( wc_get_page_id( 'myaccount' ) ); ?>orders" style="background: <?php echo get_option('hcolor3'); ?> !important; color: <?php echo get_option('hcolor4'); ?> !important;" target="_blank">تمام سفارش ها </a> 

</h3>



<div class="sefaresh34">

		<?php
			foreach ( $customer_orders as $customer_order ) :
				$order      = wc_get_order( $customer_order ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
				$item_count = $order->get_item_count();
				?>
				
				<div class="sefaresh-122-401">
				<div class="sefaresh-122-402">
				<a class="sefaresh-122-403" href="<?php echo esc_url( $order->get_view_order_url() ); ?>" target="_blank">
								<div class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $order->get_status() ); ?> order">
								<div class="dakhel-324234234">

									<?php foreach ( $my_orders_columns as $column_id => $column_name ) : ?>
									
									<?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
								<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>
							<?php elseif ( 'order-number' === $column_id ) : ?>
								<div class="nikik1">
	
								
							
									<span><?php echo _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</span></div>

							<?php elseif ( 'order-date' === $column_id ) : ?>
								<div class="niki niki666">تاریخ :  <span><time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time></span>
</div>
							<?php elseif ( 'order-status' === $column_id ) : ?>
								<div class="nikik g1"><div class="ddd-mink12"> <?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?></div></div>
</div>
							<?php elseif ( 'order-total' === $column_id ) : ?>
								<div class="nikik g2"><i class="fi fi-rr-bank"></i>  مبلغ کل  <?php
								/* translators: 1: formatted order total 2: total order items */
								printf( _n( '%1$s', '%1$s', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								?>
</div>
							<?php elseif ( 'order-actions' === $column_id ) : ?>
							
							<?php endif; ?>
					<?php endforeach; ?>

				</div>
				</a>
				</div>
				</div>
	
			<?php endforeach; ?>

</div>
		</div>
	
<?php endif; ?>

</div></div>

	
	
	
	 <?php if((get_option('acc2') == true )): ?>

<div class="elk" id="etelae">
<div class="elkone">
<h3 class="title-2">اطلاعیه های سایت

</h3>
<?php $query = new WP_Query(array('post_type' =>'elai',
	'posts_per_page'  => 10));
	if ($query){while($query->have_posts()) : $query->the_post(); ?>
	<a class="elktwo" href="<?php the_permalink(); ?>">	<?php the_post_thumbnail('thumbnail'); ?>
	<div class="elk-1">
	<span><i class="mdi mdi-timer"></i><?php the_time('d M Y'); ?></span>
	<h3><?php the_title(); ?></h3> 
	</div>
	
	</a>

	<?php endwhile; } ?>
	</div></div>	<?php endif; ?>

	<?php 
	do_action( 'woocommerce_after_my_account' );

?>
<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
