<?php
add_action( 'widgets_init', function () {
	register_widget( 'es_Blog_Widget' );
} );

class es_Blog_Widget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'es-widget-blog',
			'es - نوشته‌های بلاگ',
			array(
				'description' => 'ابزارک نمایش نوشته‌های بلاگ',
				'classname'   => 'widget-last-posts',
			) );
	}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$posts_per_page = ! empty( $instance['posts_per_page'] ) ? $instance['posts_per_page'] : 10;
		$show_date      = ! empty( $instance['show_date'] ) ? 1 : 0;
		$orderby_visit  = ! empty( $instance['orderby_visit'] ) ? 1 : 0;

		include es_TPL_PATH . 'tpl-blog.php';

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$title          = ! empty( $instance['title'] ) ? $instance['title'] : 'نوشته‌های بلاگ';
		$posts_per_page = ! empty( $instance['posts_per_page'] ) ? $instance['posts_per_page'] : 10;
		$show_date      = ! empty( $instance['show_date'] ) ? 1 : 0;
		$orderby_visit  = ! empty( $instance['orderby_visit'] ) ? 1 : 0;
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">عنوان:</label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'posts_per_page' ) ); ?>">تعداد نوشته‌ها:</label>
            <input class="small-text" id="<?php echo esc_attr( $this->get_field_id( 'posts_per_page' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'posts_per_page' ) ); ?>" type="number" value="<?php echo esc_attr( $posts_per_page ); ?>" min="1" step="1">
        </p>
        <p>
            <input id="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_date' ) ); ?>" type="checkbox" value="1" <?php echo checked( $show_date, 1 ); ?>>
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>">نمایش تاریخ</label>
        </p>
        <p>
            <input id="<?php echo esc_attr( $this->get_field_id( 'orderby_visit' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby_visit' ) ); ?>" type="checkbox" value="1" <?php echo checked( $orderby_visit, 1 ); ?>>
            <label for="<?php echo esc_attr( $this->get_field_id( 'orderby_visit' ) ); ?>">نوشته‌های پربازدید</label>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance                   = array();
		$instance['title']          = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['posts_per_page'] = ( ! empty( $new_instance['posts_per_page'] ) ) ? strip_tags( $new_instance['posts_per_page'] ) : '';
		$instance['show_date']      = ( ! empty( $new_instance['show_date'] ) ) ? strip_tags( $new_instance['show_date'] ) : '';
		$instance['orderby_visit']  = ( ! empty( $new_instance['orderby_visit'] ) ) ? strip_tags( $new_instance['orderby_visit'] ) : '';

		return $instance;
	}
}