<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */
/********************* META BOX DEFINITIONS ***********************/
/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = '';
global $meta_boxes;
$meta_boxes = array();
// 1st meta box
$meta_boxes[] = array(
// Meta box id, UNIQUE per meta box. Optional since 4.1.5
'id' => 'themeinfo',
// Meta box title - Will appear at the drag and drop handle bar. Required.
'title' => 'زمینه دلخواه زرین',
// Post types, accept custom post types as well - DEFAULT is array('post'). Optional.
'pages' => array( 'product' ),
// Where the meta box appear: normal (default), advanced, side. Optional.
'context' => 'normal',
// Order of meta box: high (default), low. Optional.
'priority' => 'high',
// List of meta fields
'fields' => array(
array(
// Field name - Will be used as label
'name'  => 'عنوان انگلیسی',
// Field ID, i.e. the meta key
'id'    => "title-1",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),
array(
// Field name - Will be used as label
'name'  => 'لینک کاتالوگ',
// Field ID, i.e. the meta key
'id'    => "catalog",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'حداکثر تا چند روز تحویل داده میشود؟',
// Field ID, i.e. the meta key
'id'    => "had",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),
array(
// Field name - Will be used as label
'name'  => 'متن ضمانت نامه',
// Field ID, i.e. the meta key
'id'    => "zemanat",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),
array(
// Field name - Will be used as label
'name'  => 'برند محصول',
// Field ID, i.e. the meta key
'id'    => "brand",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'رنگ محصول',
// Field ID, i.e. the meta key
'id'    => "colorin",
'type'  => 'color',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'محصول اصل است؟',
// Field ID, i.e. the meta key
'id'    => "asl",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),




			array(
				'id' => $prefix . 'wysiwyg_1',
				'name' => esc_html__( 'ویژگی های این محصول', 'metabox-online-generator' ),
				'type' => 'wysiwyg',
	
		),

array(
// Field name - Will be used as label
'name'  => 'رنگ های محصول ( استایل )',
// Field ID, i.e. the meta key
'id'    => "colorin1",
'type'  => 'color',
// Default value (optional)
'std'   => '',
                'clone' => true,
),
array(
// Field name - Will be used as label
'name'  => 'لینک ویدیو محصول',
// Field ID, i.e. the meta key
'id'    => "videol",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),array(
// Field name - Will be used as label
'name'  => 'لینک تصویر ویدیو',
// Field ID, i.e. the meta key
'id'    => "videoi",
'type'  => 'text',
// Default value (optional)
'std'   => '',
),

		),
	);
/********************* META BOX REGISTERING ***********************/
/**
 * Register meta boxes
 *
 * @return void
 */
function wtf_register_meta_boxes()
{
// Make sure there's no errors when the plugin is deactivated or during upgrade
if ( !class_exists( 'RW_Meta_Box' ) )
return;
global $meta_boxes;
foreach ( $meta_boxes as $meta_box )
{
new RW_Meta_Box( $meta_box );
}
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'wtf_register_meta_boxes' ); ?>