<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */
/********************* META BOX DEFINITIONS ***********************/
/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = '';
global $meta_boxes2;
$meta_boxes1 = array();
// 1st meta box
$meta_boxes2[] = array(
// Meta box id, UNIQUE per meta box. Optional since 4.1.5
'id' => 'themeinfoin1',
// Meta box title - Will appear at the drag and drop handle bar. Required.
'title' => 'زمینه دلخواه نوشته',
// Post types, accept custom post types as well - DEFAULT is array('post'). Optional.
'pages' => array( 'post' ),
// Where the meta box appear: normal (default), advanced, side. Optional.
'context' => 'normal',
// Order of meta box: high (default), low. Optional.
'priority' => 'high',
// List of meta fields
'fields' => array(
array(
// Field name - Will be used as label
'name'  => 'زمان مطالعه',
// Field ID, i.e. the meta key
'id'    => "shoghl",
'type'  => 'text',
// Default value (optional)
'std'   => 'زمان مطالعه را وارد کنید',

),

array(
// Field name - Will be used as label
'name'  => 'موضوع نوشته',
// Field ID, i.e. the meta key
'id'    => "mozo",
'type'  => 'text',
// Default value (optional)
'std'   => 'موضوع این نوشته را وارد کنید',

),
array(
// Field name - Will be used as label
'name'  => 'رنگ موضوع نوشته',
// Field ID, i.e. the meta key
'id'    => "mozocolor",
'type'  => 'color',
// Default value (optional)

),
),
);
/********************* META BOX REGISTERING ***********************/
/**
 * Register meta boxes
 *
 * @return void
 */
function wtf_register_meta_boxes2()
{
// Make sure there's no errors when the plugin is deactivated or during upgrade
if ( !class_exists( 'RW_Meta_Box' ) )
return;
global $meta_boxes2;
foreach ( $meta_boxes2 as $meta_box2 )
{
new RW_Meta_Box( $meta_box2 );
}
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'wtf_register_meta_boxes2' ); ?>