<?php 
defined( 'ABSPATH' ) || exit;

function add_invoice_settings_menu() {
    add_menu_page(
        'تنظیمات فاکتور',     // عنوان صفحه
        'تنظیمات فاکتور',     // عنوان منو
        'manage_options',      // قابلیت دسترسی
        'invoice-settings',    // اسلاگ منو
        'render_invoice_settings_page', // تابعی که محتوای صفحه تنظیمات را نمایش می‌دهد
        'dashicons-admin-generic', // آیکون منو
        80                       // موقعیت منو
    );
}
add_action( 'admin_menu', 'add_invoice_settings_menu' );


// رندر کردن صفحه تنظیمات فاکتور
function render_invoice_settings_page() {
    include( locate_template( '/ffile/factor/factor-setting.php' ) );
}





// ثبت تنظیمات
function register_invoice_settings() {
    register_setting( 'invoice_settings_group', 'invoice_sender_name' );
    register_setting( 'invoice_settings_group', 'invoice_sender_email' );
    register_setting( 'invoice_settings_group', 'invoice_sender_phone' );
    register_setting( 'invoice_settings_group', 'invoice_sender_meli' );
    register_setting( 'invoice_settings_group', 'invoice_sender_post' );
    register_setting( 'invoice_settings_group', 'invoice_sender_number' );
    register_setting( 'invoice_settings_group', 'invoice_sender_address' );
    register_setting( 'invoice_settings_group', 'invoice_sender_logo' );
    register_setting( 'invoice_settings_group', 'invoice_sender_mohr' );
	register_setting( 'invoice_settings_group', 'invoice_enabled' );
	register_setting( 'invoice_settings_group', 'invoice_enabledtwo' );

    add_settings_section(
        'invoice_settings_section', // ID بخش
        'تنظیمات فروشنده', // عنوان بخش
        null, // تابع توضیحات
        'invoice-settings' // صفحه تنظیمات
    );

add_settings_field(
        'invoice_enabled', // ID فیلد
        'فعال کردن دکمه فاکتور برای کاربر', // عنوان فیلد
        'render_invoice_enabled_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
	add_settings_field(
        'invoice_enabledtwo', // ID فیلد
        'فعال کردن فاکتور حرفه ای', // عنوان فیلد
        'render_invoice_enabledtwo_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
    add_settings_field(
        'invoice_sender_name', // ID فیلد
        'نام فروشنده', // عنوان فیلد
        'render_invoice_sender_name_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
    add_settings_field(
        'invoice_sender_email', // ID فیلد
        'ایمیل فروشنده', // عنوان فیلد
        'render_invoice_sender_email_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
   add_settings_field(
        'invoice_sender_phone', // ID فیلد
        'شماره فروشنده', // عنوان فیلد
        'render_invoice_sender_phone_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
    add_settings_field(
        'invoice_sender_address', // ID فیلد
        'آدرس ارسال کننده', // عنوان فیلد
        'render_invoice_sender_address_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );

   add_settings_field(
        'invoice_sender_meli', // ID فیلد
        'شماره ملی', // عنوان فیلد
        'render_invoice_sender_meli_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );

add_settings_field(
        'invoice_sender_post', // ID فیلد
        'کد پستی فروشنده', // عنوان فیلد
        'render_invoice_sender_post_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
	
	   add_settings_field(
        'invoice_sender_logo', // ID فیلد
        'لوگو سایت', // عنوان فیلد
        'render_invoice_sender_logo_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
	
		   add_settings_field(
        'invoice_sender_mohr', // ID فیلد
        'مهر یا امضا فروشنده', // عنوان فیلد
        'render_invoice_sender_mohr_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );
	add_settings_field(
        'invoice_sender_number', // ID فیلد
        'شماره اقتصادی', // عنوان فیلد
        'render_invoice_sender_number_field', // تابع رندر فیلد
        'invoice-settings', // صفحه تنظیمات
        'invoice_settings_section' // بخش تنظیمات
    );


}
add_action( 'admin_init', 'register_invoice_settings' );

function register_invoice_style_settings() {
    register_setting( 'invoice_style_settings_group', 'invoice_font_size' );
    register_setting( 'invoice_style_settings_group', 'invoice_color_scheme' );

    add_settings_section(
        'invoice_style_settings_section', // ID بخش
        'تنظیمات استایل فاکتور', // عنوان بخش
        null, // تابع توضیحات
        'invoice-style-settings' // صفحه تنظیمات
    );

    add_settings_field(
        'invoice_font_size', // ID فیلد
        'اندازه فونت', // عنوان فیلد
        'render_invoice_font_size_field', // تابع رندر فیلد
        'invoice-style-settings', // صفحه تنظیمات
        'invoice_style_settings_section' // بخش تنظیمات
    );

    add_settings_field(
        'invoice_color_scheme', // ID فیلد
        'طرح رنگ', // عنوان فیلد
        'render_invoice_color_scheme_field', // تابع رندر فیلد
        'invoice-style-settings', // صفحه تنظیمات
        'invoice_style_settings_section' // بخش تنظیمات
    );
}
add_action( 'admin_init', 'register_invoice_style_settings' );


function render_invoice_enabled_field() {
    $value = get_option( 'invoice_enabled', '0' ); // مقدار پیش‌فرض 0 (غیرفعال)
    echo '
	<style>
	input:checked + .slider {
  background-color: #2196F3;
}
.switch {
	position: relative;
	display: inline-block;
	width: 60px;
	height: 34px;
}
.slider {
	position: absolute;
	cursor: pointer;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	background-color: #ccc;
	transition: .4s;
	border-radius: 34px;
}
.slider::before {
	position: absolute;
	content: "";
	height: 26px;
	width: 26px;
	border-radius: 50%;
	left: 4px;
	bottom: 4px;
	background-color: white;
	transition: .4s;
}
input:checked + .slider::before {
	transform: translateX(26px);
}
</style>
	<label class="switch">
            <input type="checkbox" name="invoice_enabled" value="1" ' . checked( 1, $value, false ) . ' />
            <span  class="slider"></span>
          </label>';
}
function render_invoice_enabledtwo_field() {
    $value = get_option( 'invoice_enabledtwo', '0' ); // مقدار پیش‌فرض 0 (غیرفعال)
    echo '
	<style>
	input:checked + .slider {
  background-color: #2196F3;
}
.switch {
	position: relative;
	display: inline-block;
	width: 60px;
	height: 34px;
}
.slider {
	position: absolute;
	cursor: pointer;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	background-color: #ccc;
	transition: .4s;
	border-radius: 34px;
}
.slider::before {
	position: absolute;
	content: "";
	height: 26px;
	width: 26px;
	border-radius: 50%;
	left: 4px;
	bottom: 4px;
	background-color: white;
	transition: .4s;
}
input:checked + .slider::before {
	transform: translateX(26px);
}
</style>
	<label class="switch">
            <input type="checkbox" name="invoice_enabledtwo" value="1" ' . checked( 1, $value, false ) . ' />
            <span  class="slider"></span>
          </label>';
}

// رندر فیلد نام ارسال کننده
function render_invoice_sender_name_field() {
    $value = get_option( 'invoice_sender_name', '' );
    echo '<input type="text" name="invoice_sender_name" value="' . esc_attr( $value ) . '" class="regular-text" />';
}
function render_invoice_sender_email_field() {
    $value = get_option( 'invoice_sender_email', '' );
    echo '<input type="text" name="invoice_sender_email" value="' . esc_attr( $value ) . '" class="regular-text" />';
}


function render_invoice_sender_phone_field() {
    $value = get_option( 'invoice_sender_phone', '' );
    echo '<input type="text" name="invoice_sender_phone" value="' . esc_attr( $value ) . '" class="regular-text" />';
}
function render_invoice_sender_meli_field() {
    $value = get_option( 'invoice_sender_meli', '' );
    echo '<input type="text" name="invoice_sender_meli" value="' . esc_attr( $value ) . '" class="regular-text" />';
}


function render_invoice_sender_post_field() {
    $value = get_option( 'invoice_sender_post', '' );
    echo '<input type="text" name="invoice_sender_post" value="' . esc_attr( $value ) . '" class="regular-text" />';
}
function render_invoice_sender_logo_field() {
    $value = get_option( 'invoice_sender_logo', '' );
    echo '<input type="text" name="invoice_sender_logo" value="' . esc_attr( $value ) . '" class="regular-text" />';
}
function render_invoice_sender_mohr_field() {
    $value = get_option( 'invoice_sender_mohr', '' );
    echo '<input type="text" name="invoice_sender_mohr" value="' . esc_attr( $value ) . '" class="regular-text" />';
}


function render_invoice_sender_number_field() {
    $value = get_option( 'invoice_sender_number', '' );
    echo '<input type="text" name="invoice_sender_number" value="' . esc_attr( $value ) . '" class="regular-text" />';
}




// رندر فیلد آدرس ارسال کننده
function render_invoice_sender_address_field() {
    $value = get_option( 'invoice_sender_address', '' );
    echo '<textarea name="invoice_sender_address" class="large-text" rows="5">' . esc_textarea( $value ) . '</textarea>';
}

// رندر فیلد اندازه فونت
function render_invoice_font_size_field() {
    $value = get_option( 'invoice_font_size', '' );
    echo '<input type="number" name="invoice_font_size" value="' . esc_attr( $value ) . '" class="regular-text" />';
}

// رندر فیلد طرح رنگ
function render_invoice_color_scheme_field() {
    $value = get_option( 'invoice_color_scheme', '' );
    echo '<input type="text" name="invoice_color_scheme" value="' . esc_attr( $value ) . '" class="regular-text" />';
}





/* بارکد ساز */










// نمایش لینک فاکتور در صفحه ویرایش سفارش در قسمت مدیریت
function display_custom_invoice_link_on_admin_order_page( $order ) {
    $order_number = $order->get_order_number();
    $invoice_link = home_url( "/factor/?order_id={$order_number}" );
    ?>
    <div class="invoice-link">
        <a style="background: #2962FF;color: #fff;text-decoration: none;padding: 15px;float: right;margin-top: 15px;font-family: yekan bakh;border-radius: 10px;font-size: 16px;" href="<?php echo esc_url( $invoice_link ); ?>" target="_blank">فاکتور سفارش</a>
    </div>
    <?php
}
add_action( 'woocommerce_admin_order_data_after_order_details', 'display_custom_invoice_link_on_admin_order_page', 10, 1 );






// add_action( 'woocommerce_order_status_completed', 'save_order_invoice_as_html', 10, 1 );

//function save_order_invoice_as_html( $order_id ) {
  //  $order = wc_get_order( $order_id );

  //  if ( ! $order ) {
  //      return;
  //  }

    // تولید HTML فاکتور با بارگذاری صفحه factor-page.php
  //  ob_start();
 //   include( locate_template( 'mehr/factor/factor.php' ) );
  //  $html_content = ob_get_clean();

 // مسیر فایل ذخیره شده
  //  $upload_dir = wp_upload_dir();
  //  $invoice_dir = $upload_dir['basedir'] . '/invoices';

    // ایجاد پوشه invoices در صورت عدم وجود
 //   if ( ! file_exists( $invoice_dir ) ) {
  //      wp_mkdir_p( $invoice_dir );
 //   }
	
	
   // if ( ! file_exists( $invoice_dir ) ) {
    //    mkdir( $invoice_dir, 0755, true );
  //  }

  //  $file_path = $invoice_dir . '/invoice-' . $order->get_order_number() . '.html';

    // ذخیره HTML در فایل
    //file_put_contents( $file_path, $html_content );
//}


