<?php
namespace Elementor;

class wp1 extends Widget_Base {
	
	public function get_name() {
		return 'wp1';
	}
	
	public function get_title() {
		return 'اسلایدر مطالب 1';
	}
	
  public function get_icon() {
		return 'eicon eicon-post-content';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'تنظیمات مطالب', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);


		$this->end_controls_section();
		
		
		


        	       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش توضیحات', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش نویسنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		

		         $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'کادر عنوان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'مخفی', 'your-plugin' ),
				'label_off' => __( 'نمایش', 'your-plugin' ),
				'return_value' => 'no',
				'default' => 'no',
			]
		);
		
		    
		
        $this->end_controls_section();


   


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>
			<script>
			
			   $(document).ready(function(){
$('.owl-blog401').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});

</script>
		                   <div class="owl-blog401 owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="product-list234234 try4554g4gr">
<div class="product-list-1234234">

<a  href="<?php the_permalink(); ?>">
	<?php the_post_thumbnail(''); ?>
<h3><?php the_title(); ?></h3>
</a>
 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<div class="list-dec">
<?php
$excerpt = get_the_excerpt();

$excerpt = substr($excerpt, 0, 160);
$result = substr($excerpt, 0, strrpos($excerpt, ' '));
echo $result;
?></div>
<?php } ?>

<div class="list-meta">

 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<span class="list-meta-133334">
<?php
// Get author ID
$author_id = get_the_author_meta('ID');

// Get attachment ID
$avatar_attachment_id = get_user_meta($author_id, 'avatar', true);

// Get default avatar URL
$default_avatar_url = get_template_directory_uri() . '/img/user.jpg';

// Display author avatar
if ($avatar_attachment_id) {
  // Get image URL
  $avatar_url = wp_get_attachment_url($avatar_attachment_id);
  if ($avatar_url) {
    echo '<img src="' . esc_url($avatar_url) . '" alt="Author Avatar" width="100" height="100">';
  } else {
    // Display default avatar
    echo '<img src="' . esc_url($default_avatar_url) . '" alt="Default Avatar" width="100" height="100">';
  }
} else {
  // Display default avatar
  echo '<img src="' . esc_url($default_avatar_url) . '" alt="Default Avatar" width="100" height="100">';
}
?>
<h5><?php echo get_the_author_meta('display_name'); ?> </h5>

</span><?php } ?>
 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>


<span class="list-meta-2445435">
<?php the_time('d M Y'); ?>
</span><?php } ?>
</div>
</div></div>
			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}