<?php
namespace Elementor;

class headertwo extends Widget_Base {
	
	public function get_name() {
		return 'headertwo';
	}
	
	public function get_title() {
		return 'جستجو سربرگ';
	}
	
	    public function get_icon() {
		return 'eicon eicon-search';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید', 'elementor' ),
			]
		);

	

		$this->end_controls_section();
		
		
		 $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		
				   $this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ پس زمینه جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .searchnav.header-two-two-2' => 'background: {{VALUE}} !important',
				],
			]
           );
 $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ ایکون جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .dgwt-wcas-has-submit .dgwt-wcas-search-submit svg path' => 'fill: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   
		   			$this->add_responsive_control(
                        'farnam-p-356',
                        [
                            'label' => esc_html__( 'گردی دور جعبه جستجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .searchnav.header-two-two-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',

                            ],
                        ]
                    );
		   $this->add_responsive_control(
                        'farnam-p-356444',
                        [
                            'label' => esc_html__( 'گردی جعبه بازشونده' , 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .dgwt-wcas-suggestions-wrapp.woocommerce.dgwt-wcas-has-img.dgwt-wcas-has-price.dgwt-wcas-has-headings.js-dgwt-wcas-initialized' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',

                            ],
                        ]
                    );
		   		$this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'فاصله از بیرون', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .searchnav.header-two-two-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
			$this->add_responsive_control(
			'title_padding',
			[
				'label' => __( 'فاصله از داخل', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .searchnav.header-two-two-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
			$this->add_control(
			'ertefah',
			[
				'label' => __( 'ارتفاع جعبه جستجو', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
	'selectors' => [
					'{{WRAPPER}} .searchnav.header-two-two-2' => 'height: {{UNIT}}px;',
				],			]
		);
		
          		$this->end_controls_section();

	}
	
	protected function render() {
		include es_TPL_PATH . 'header-two.php';
	}
	
	protected function _content_template() {

    }
	
	
}