<?php
namespace Elementor;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class imagesingle extends Widget_Base {
	
	public function get_name() {
		return 'imagesingle';
	}

	public function get_title() {
		return esc_html__( 'تصویر محصول', 'elementor-pro' );
	}

	public function get_icon() {
		return 'eicon eicon-product-images';
	}

    public function get_categories() {
        return [ 'farnamproduct' ];
    }
	protected function register_controls() {

			
		
  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

    

		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12' => 'background: {{VALUE}} !important',
				],
			]
           );

		   
  $this->add_control(
'sepidcolor-5fr1',
			[
				'label' => __( 'پس زمینه تصویر اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-viewport' => 'background: {{VALUE}} !important',
				],
			]
           );

$this->add_control(
'sepidcolor-5fr15tgg',
			[
				'label' => __( 'کادر باکس تصاویر کوچک', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-control-nav.flex-control-thumbs' => 'border-top-color: {{VALUE}} !important',
				],
			]
           );

$this->add_control(
'sepidcolor-5fr15tgergtg',
			[
				'label' => __( 'پس زمینه تصاویر کوچک', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-control-nav.flex-control-thumbs li' => 'background: {{VALUE}} !important',
				],
			]
           );

 $this->add_control(
                        'titr-mehr-4',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );

			$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12',
			]
		);
			
				  $this->add_control(
                        'titr-mehr-2',
                        [
                            'label' => __( 'کادر باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border-mehr-2',
				'selector' => '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12',
			]
		);	
				$this->add_responsive_control(
			'title_padding',
			[
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'label' => esc_html__( 'فاصله داخلی', 'textdomain' ),
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		  $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ پس زمینه بزرگنمایی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .padd-new-402 .woocommerce-product-gallery__trigger' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ ایکون بزرگنمایی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .padd-new-402 .woocommerce-product-gallery__trigger::before' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	
		  $this->add_control(
'sepidcolor-467',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .mizan-flash5555' => 'background: {{VALUE}} !important',
				],
			]
           );
	
	
   $this->add_control(
'sepidcolor-4671',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .mizan-flash5555' => 'color: {{VALUE}} !important',
				],
			]
           );
	
				
		
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					 $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی باکس دور تصویر اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-viewport' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					 $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی تصویر اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-viewport .woocommerce-product-gallery__image a img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی بزرگنمایی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .woocommerce-product-gallery__trigger' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						$this->add_responsive_control(
                        'sepidborder-6',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .mizan-flash5555' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						$this->add_responsive_control(
                        'sepidborder-7',
                        [
                            'label' => esc_html__( 'گردی تصاویر کوچک', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-control-nav.flex-control-thumbs li' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .woocommerce-product-gallerynewimagebox12 .flex-control-nav.flex-control-thumbs li img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
		
	}
	
 protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        global $product;
        $product = wc_get_product();

     
            if ( empty( $product ) ) { return; }
            $current_theme = wp_get_theme();
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
		
			 
			 echo "<div class='woocommerce-product-gallerynewimagebox12'>";
			 ?>
			 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>	<?php if ( $product->is_on_sale() ) : ?>

			 	<div class="mizan-flash5555">
<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>
	
			 </div>	<?php
endif;

?><?php } ?>
<?php
            if( $current_theme->get( 'TextDomain' ) == 'woostify' ){
                do_action( 'woocommerce_before_single_product_summary' );
                echo '</div></div></div>';
            }elseif( $current_theme->get( 'TextDomain' ) == 'blocksy' ){
                woocommerce_show_product_sale_flash();
                woocommerce_show_product_images();
            }else{
                do_action( 'woocommerce_before_single_product_summary' );
           echo '</div>';

        }

    }

}
