<?php
namespace Elementor;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class addsingle extends Widget_Base {
	
	public function get_name() {
		return 'addsingle';
	}

	public function get_title() {
		return esc_html__( 'افزودن به سبد خرید و قیمت', 'elementor-pro' );
	}

 public function get_icon() {
		return 'eicon eicon-product-add-to-cart';
    }
    
    public function get_categories() {
        return [ 'farnamproduct' ];
    }

	protected function register_controls() {

	 $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


 $this->add_control(
'sepidcolor-1wa',
			[
				'label' => __( 'رنگ پس زمینه قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woo-price-single432 .price' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
$this->add_control(
'sepidcolor-1wa1',
			[
				'label' => __( 'رنگ المان های کنار قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woo-price-single432 .price::before' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .woo-price-single432 .price::after' => 'background: {{VALUE}} !important',
				],
			]
           );

		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woo-price-single432 .price' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .woo-price-single432 .price ins' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	    $this->add_control(
'sepidcolor-2fr',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .woo-price-single432 del' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	
		   
		     $this->add_control(
'sepidcolor-2fr2',
			[
				'label' => __( 'رنگ متن متغیر ها', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .variations .label label' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		    $this->add_control(
'sepidcolor-2fr3',
			[
				'label' => __( 'رنگ المان کنار متغیر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .variations tr td.label::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		       $this->add_control(
'sepidcolor-2fr4',
			[
				'label' => __( 'رنگ پس زمینه پاک کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .reset_variations' => 'background: {{VALUE}} !important',
				],
			]
           );
		     $this->add_control(
'sepidcolor-2fr5',
			[
				'label' => __( 'رنگ متن پاک کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .reset_variations' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		     $this->add_control(
'sepidcolor-2fr6',
			[
				'label' => __( 'رنگ پس زمینه شمارشگر محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity input' => 'background: {{VALUE}} !important',
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity-controlsghgggffrrrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   $this->add_control(
'sepidcolor-2fr7',
			[
				'label' => __( 'رنگ متن شمارشگر محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity input' => 'color: {{VALUE}} !important',
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity-controlsghgggffrrrr .plus' => 'color: {{VALUE}} !important',
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity-controlsghgggffrrrr .minus' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		    $this->add_control(
'sepidcolor-2fr9',
			[
				'label' => __( 'رنگ کادر انتخاب گر شمارشگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity input' => 'border-color: {{VALUE}} !important',
					'{{WRAPPER}}  .woo-price-single432 .cart .quantity-controlsghgggffrrrr' => 'border-color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   	    $this->add_control(
'sepidcolor-2fr10',
			[
				'label' => __( 'رنگ پس زمینه افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 form.cart button.button' => 'background: {{VALUE}} !important',
				],
			]
           );
		      	    $this->add_control(
'sepidcolor-2fr15',
			[
				'label' => __( 'رنگ متن افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 form.cart button.button' => 'color: {{VALUE}} !important',
				],
			]
           );
$this->add_control(
'sepidcolor-2fr11',
			[
				'label' => __( 'رنگ هاور پس زمینه افزودن به سبد خرید ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
 
				'selectors' => [
					'{{WRAPPER}} .woo-price-single432 form.cart button.button:hover' => 'background: {{VALUE}} !important',
				],
			]
      );
		    $this->add_control(
'sepidcolor-2fr14',
			[
				'label' => __( 'رنگ هاور متن افزودن به سبد خرید ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 form.cart button.button:hover' => 'color: {{VALUE}} !important',
				],
			]
           );
		     $this->add_control(
'sepidcolor-2fr12',
			[
				'label' => __( 'رنگ پس زمینه غیر فعال افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 form.cart button.button.disabled' => 'background: {{VALUE}} !important',
				],
			]
           );
		   	     $this->add_control(
'sepidcolor-2fr13',
			[
				'label' => __( 'رنگ متن غیر فعال افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}  .woo-price-single432 form.cart button.button.disabled' => 'color: {{VALUE}} !important',
				],
			]
           );

		   

	
		
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی پاک کننده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woo-price-single432 .reset_variations' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
					 $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی شمارنده محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woo-price-single432 .cart .quantity .qty' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .woo-price-single432 .cart .quantity-controlsghgggffrrrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی افزودن به سبد خرید', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woo-price-single432 form.cart button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						$this->add_responsive_control(
                        'sepidborder-55',
                        [
                            'label' => esc_html__( 'گردی دور قیمت', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .woo-price-single432 .price' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
	}
	
 protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        global $product;
        $product = wc_get_product();

     
            if ( empty( $product ) ) { return; }
            $current_theme = wp_get_theme();
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
			 echo "<div class='woo-price-single432'>";

                do_action( 'woocommerce_single_product_summary' );      
           echo '</div>';

       

    }

}
