<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class offerseven extends Widget_Base {

    public function get_name() {
        return 'offerseven';
    }
    
    public function get_title() {
        return __( 'محصولات شگفت انگیز 8', 'woolentor' );
    }

     public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }


    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'Product Settings', 'woolentor' ),
            ]
        );
        
            
			$this->add_control(
			'onvan',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید ', 'elementor' ),
			]
		);
            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
												 'show_byid'     => esc_html__( 'انتخاب محصول', 'woolentor' ),

                    ],
                ]
            );
            $this->add_control(
                'woolentor_product_id',
                [
                    'label'         => __( 'چند محصول انتخاب کنید', 'woolentor' ),
                    'type'          => Controls_Manager::SELECT2,
                    'label_block'   => true,
                    'multiple'      => true,
                    'options'       => woolentor_post_name( 'product' ),
                    'condition'     => [
                        'woolentor_product_grid_product_filter' => 'show_byid',
                    ]
                ]
            );

                   $this->add_control(
                'woolentor_product_ids_manually',
                [
                    'label'         => __( 'Product IDs', 'woolentor' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block'   => true,
                    'condition'     => [
                        'woolentor_product_grid_product_filter' => 'show_byid_manually',
                    ]
                ]
            );
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون - ', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

	

			$this->add_control(
			'code_slider',
			[
				'label' => __( 'کد اسلایدر ', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا : d99 ', 'elementor' ),
			]
		);
		$this->add_control(
			'zaman',
			[
				'label' => __( 'زمان اتمام تخفیف  ( میلادی ) ', 'elementor' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::DATE_TIME,
				'placeholder' => __( 'به میلادی : 12/04/2020 ', 'elementor' ),
			]
		);
		

        $this->end_controls_section();


        
		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تایمر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
           
		
		       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش درصد تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش قیمت', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             



		 
			      	$this->add_control(
			'more_optionsr5',
			[
				'label' => __( 'پس زمینه اسلایدر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'saliderpas',
				'label' => __( 'پس زمینه اسلایدر', 'plugin-domain' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .paszamine-gaj',
			]
		);

$this->add_control(
			'color21',
			[
				'label' => __( 'رنگ المان پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .gerd-nim-plus path' => 'fill: {{VALUE}} !important',
				],
			]
		);
		
$this->add_control(
			'color22',
			[
				'label' => __( 'پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.offer-8-gaj.paszamine-gaj.ns-402-14.mhr-403-1 .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
		);
$this->add_control(
			'color23',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.offer-8-gaj.paszamine-gaj.ns-402-14.mhr-403-1 .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_control(
			'color24',
			[
				'label' => __( 'رنگ عنوان اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-lus-ss-402 .spand4433454' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_control(
			'color26',
			[
				'label' => __( 'رنگ پس زمینه تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer322 ' => 'backgtound: {{VALUE}} !important',
				],
			]
		);
			$this->add_control(
			'color26899987',
			[
				'label' => __( 'رنگ متن تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer322 .tarh-gaj-offer' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'color27',
			[
				'label' => __( 'رنگ ایکون تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer322 i' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
		
		$this->add_control(
			'color28',
			[
				'label' => __( 'رنگ پس زمینه محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-ss-plus' => 'background: {{VALUE}} !important',
				],
			]
		);
		
			$this->add_control(
			'color29',
			[
				'label' => __( 'رنگ پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-ss-plus-two' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		
			$this->add_control(
			'color30',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-ss-plus-one-title' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'color31',
			[
				'label' => __( 'رنگ قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizany4rrr-price64' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .ht-row.offer-8-gaj.paszamine-gaj.ns-402-14.mhr-403-1 .mizany4rrr-price64 ins' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
			$this->add_control(
			'color32',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizany4rrr-price64 del' => 'color: {{VALUE}} !important',
				],
			]
		);
			$this->add_control(
			'color33',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizany4rrr' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_control(
			'color34',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizany4rrr' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
		$this->add_responsive_control(
                        'farnam-p-2',
                        [
                            'label' => esc_html__( 'گردی دور اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .paszamine-gaj' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
		
		$this->add_responsive_control(
                        'farnam-p-3',
                        [
                            'label' => esc_html__( 'گردی دور محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-ss-plus' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
							
		$this->add_responsive_control(
                        'farnam-p-3td',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-ss-plus-two' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .product-ss-plus-two img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
						$this->add_responsive_control(
                        'farnam-p-35',
                        [
                            'label' => esc_html__( 'گردی درصد تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mizany4rrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
					
							$this->add_responsive_control(
                        'farnam-p-356',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ht-row.offer-8-gaj.paszamine-gaj.ns-402-14.mhr-403-1 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',

                            ],
                        ]
                    );
					
						
							$this->add_responsive_control(
                        'farnam-p-3567',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .iran-pak-offer322' => 'border-radius: 0px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
						
        $this->end_controls_section();

             


          



    }

    protected function render( $instance = [] ) {
	
$settings = $this->get_settings_for_display();
	
		
		$due_date = strtotime( $this->get_settings( 'zaman' ) );
		$due_date_in_days = $due_date / DAY_IN_SECONDS;
        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
			
  case 'show_byid':
                $args['post__in'] = $settings['woolentor_product_id'];
            break;
			
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
				<h4 class="product-lus-ss-402"><span class="spand4433454"><?php echo '' . $settings['onvan'] . ''; ?> </span>
				
 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

				
				<div class="iran-pak-offer322">
				<i class="mdi mdi-timelapse"></i>


<div id="fmroffer<?php echo '' . $settings['code_slider'] . ''; ?>" class="tarh-gaj-offer"></div>
<script type="text/javascript">
  $("#fmroffer<?php echo '' . $settings['code_slider'] . ''; ?>")
  .countdown("<?php echo '' . $settings['zaman'] . ''; ?>", function(event) {
    $(this).text(
      event.strftime('%D:%H:%M:%S')
	
    );
  });
</script>
</div><?php } ?>
				</h4>
			
                <div class="ht-row offer-8-gaj paszamine-gaj ns-402-14 mhr-403-1">
				<svg xmlns="http://www.w3.org/2000/svg" width="231" height="75" viewBox="0 0 231 75" fill="none" class="gerd-nim-plus">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M0 0C31.5006 0.949537 50.52 17.872 56.1955 26.4544L55.986 25.8011L82.4924 58.631C99.3032 79.4521 131.038 79.4521 147.849 58.6309L174.356 25.8011L174.146 26.4544C179.822 17.872 198.844 0.949537 230.349 0H0Z" fill="#FCFCFC"></path>
            </svg>
			
                 <script>           $(document).ready(function(){
$('.owl-offer-9df').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        360:{
            items:2,
			        margin:0

        },
		   700:{
            items:3
        },
        1200:{
            items:5
        }
    }
})
});</script>
   <div class="owl-offer-9df owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
							
							
							<div class="product-ss-plus"><a  href="<?php the_permalink(); ?>">

								<div class="product-ss-plus-one">
								<div class="product-ss-plus-one-title">
<?php the_title(); ?></div>
<div class="price-plus-ss">
 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="mizany4rrr">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo' , $product ); ?>


</div>
<?php } ?>
<?php } ?> <?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

<div class="mizany4rrr-price64">

<?php global $product; echo $product->get_price_html(); ?>

</div><?php } ?></div>
							</div>
							
								<div class="product-ss-plus-two">
																<?php the_post_thumbnail('woocommerce_thumbnail'); ?>

							</div>
							</a>

							</div>


                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>
        </div>  


        <?php

    }


}


