<?php
namespace Elementor;

class search3 extends Widget_Base {
	
	public function get_name() {
		return 'search3';
	}
	
	public function get_title() {
		return 'جستجو 3';
	}
	
	    public function get_icon() {
		return 'eicon eicon-search';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);

		$this->end_controls_section();
		
		

		 $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             

		   

		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ پس زمینه متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} #newheadsearch input' => 'background: {{VALUE}} !important',
				],
			]
           );
		   	   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input::placeholder' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'پس زمینه دکمه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} #newheadsearch .dgwt-wcas-search-submit' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} #newheadsearch .dgwt-wcas-search-submit .dgwt-wcas-ico-magnifier path' => 'fill: {{VALUE}} !important',
				],
			]
           );
		   
		   		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی کادر نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #newheadsearch input' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					   		   $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دکمه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #newheadsearch .dgwt-wcas-search-submit' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						   $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی کادر بازشونده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .dgwt-wcas-suggestions-wrapp.woocommerce.dgwt-wcas-has-img.dgwt-wcas-has-price.dgwt-wcas-has-headings.js-dgwt-wcas-initialized' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		


		?>
      <div class="search-new-style-1400 mlk-435345" id="newheadsearch"><?php echo do_shortcode('[wcas-search-form]'); ?>

</div>
		<?php


	}


	
	protected function _content_template() {

    }
	
	
}