<?php
namespace Elementor;

class menumobile extends Widget_Base {
	
public function get_menu_options() {
    $menus = wp_get_nav_menus();
    $options = ['' => 'بدون منو'];
    foreach ($menus as $menu) {
        $options[$menu->term_id] = $menu->name;
    }

    return $options;
}

	public function get_name() {
		return 'menumobile';
	}
	
	public function get_title() {
		return 'منو موبایل';
	}
	
	    public function get_icon() {
		return 'eicon eicon-header';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید', 'elementor' ),
			]
		);

			
$this->add_control(
    'menu_dropdown',
    [
        'label'       => __( 'انتخاب فهرست', 'text-domain' ),
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => $this->get_menu_options(), // تابعی که فهرست‌های سایت را برمی‌گرداند
    ]
);
		
	
				$this->add_control(

		'color-four1',
			[
				'label' => __( 'رنگ پس زمینه ایکون منو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .left-sabad.menu-resp.mn-402-3' => 'background: {{VALUE}} !important',
				],
			]
		);
		
				$this->add_control(

		'color-four2',
			[
				'label' => __( 'رنگ آیکون منو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .left-sabad.menu-resp.mn-402-3' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
				$this->add_control(

		'color-four143534',
			[
				'label' => __( 'رنگ پس زمینه دکمه جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mob-1 .submit.icon-search' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(

		'color-four143544434',
			[
				'label' => __( 'رنگ متن دکمه جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mob-1 .submit.icon-search' => 'color: {{VALUE}} !important',
				],
			]
		);
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی ایکون منو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .left-sabad.menu-resp.mn-402-3' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		

		?>



<a class="left-sabad menu-resp mn-402-3" onclick="openNav()">
<i class="mdi mdi-menu"></i>
</a>




<div id="rgg45555">

  <a href="javascript:void(0)" class="closebtny6" onclick="closeNav1()">
  </a>

<div id="mySidenav" class="menu-mobile-111">


  <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
<div class="mob-1"> 
          <form class="search" method="get" action="<?php bloginfo('url'); ?>">
<input type="text" placeholder="دنبال چی هستی؟
" onfocus="if (this.value == '') {this.value = '';}" onblur="if (this.value == '') {this.value = '';}" name="s" class="text">

<button type="submit" class="submit icon-search"><i class="mdi mdi-magnify"></i></button>
<input type="hidden" name="post_type" value="product" />
</form>

</div>
	
<div class="mobile-menu-1 stellarnav">

<?php


   
    if (!empty($settings['menu_dropdown'])) {
        $menu_id = $settings['menu_dropdown'];

        
        if ($menu_id && is_nav_menu($menu_id)) {
            wp_nav_menu(array(
                'menu' => $menu_id,
                            'container' => '',
                            'container_class' => '',
                            'container_id' => '',
                            'menu_class' => 'main_menu',
                            'menu_id' => '',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
							    'add_li_class'  => 'mega',
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => ' ',
                            'items_wrap' => '<ul id="header_main_nav" class="nav header-nav header-bottom-nav nav-center  nav-uppercase">%3$s</ul>',
                            'depth' => 0,
                            'walker' => ''
						
            ));


        }
    }
	
	else {

?>
 <?php 
                        $defaults = array(
                            'theme_location' => 'header-menu',
                            'menu' => '',
                            'container' => '',
                            'container_class' => '',
                            'container_id' => '',
                            'menu_class' => 'main_menu',
                            'menu_id' => '',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
							    'add_li_class'  => 'mega',
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => ' ',
                            'items_wrap' => '<ul id="header_main_nav" class="nav header-nav header-bottom-nav nav-center  nav-uppercase">%3$s</ul>',
                            'depth' => 0,
                            'walker' => ''
                            );
                        wp_nav_menu($defaults);
                    ?>
					
	<?php } ?>

</div>
</div></div>

<!-- required -->
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			jQuery('.stellarnav').stellarNav({
				theme: 'dark',
				breakpoint: 3000,
				position: 'right',
				phoneBtn: '',
				locationBtn: ''
			});
		});
	</script>
	<!-- required -->
	

	 <script>
/* Set the width of the side navigation to 250px */
function openNav() {
  document.getElementById("rgg45555").style.transform = "unset";
  document.getElementById("rgg45555").style.overflow = "unset";
  document.getElementById("rgg45555").style.visibility = "unset";
  document.getElementById("rgg45555").style.opacity = "1";
}

/* Set the width of the side navigation to 0 */
function closeNav() {
  document.getElementById("rgg45555").style.transform = "translateX(100%)";
    document.getElementById("rgg45555").style.overflow = "hidden";
  document.getElementById("rgg45555").style.visibility = "hidden";
  document.getElementById("rgg45555").style.opacity = "0";
} 

function closeNav1() {
  document.getElementById("rgg45555").style.transform = "translateX(100%)";
      document.getElementById("rgg45555").style.overflow = "hidden";
  document.getElementById("rgg45555").style.visibility = "hidden";
  document.getElementById("rgg45555").style.opacity = "0";
} 

</script>

		<?php
	}
	
	protected function _content_template() {

    }
	
	
}