<?php
namespace Elementor;

class newmenu extends Widget_Base {
	
	    /**
     * Get menu options.
     *
     * @return array
     */
public function get_menu_options() {
    $menus = wp_get_nav_menus();
    $options = [];

    foreach ($menus as $menu) {
        $options[$menu->term_id] = $menu->name;
    }

    return $options;
}


	public function get_name() {
		return 'newmenu';
	}
	
	public function get_title() {
		return 'منو اختصاصی';
	}
	
	    public function get_icon() {
		return 'eicon eicon-header';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		
		$this->add_control(
    'menu_dropdown',
    [
        'label'       => __( 'انتخاب فهرست', 'text-domain' ),
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => $this->get_menu_options(), // تابعی که فهرست‌های سایت را برمی‌گرداند
    ]
);



	$this->add_control(
'menu-size',
			[
				'label' => __( 'حداقل ارتفاع منو تب', 'plugin-domain' ),
				'type' => Controls_Manager::TEXT,
								'placeholder' => __( '470', 'elementor' ),
				'selectors' => [
					'{{WRAPPER}} #menucolornew43  .dmega .sub-menu' => 'min-height: {{VALUE}}px ',
					'{{WRAPPER}} #menucolornew43  .dmega .sub-menu li .sub-menu' => 'min-height: {{VALUE}}px ',
				
				],
			]
		);

	   $this->add_control(
'color_farnam_342',
			[
				'label' => __( 'رنگ متن منو اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .menu-header ul li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .menu-header ul li .sub-menu li a' => 'color: #353B44',
				

				],
			]
           );
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ بندی منو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .menu-item-has-children:hover a::after' => 'border-bottom-color: {{VALUE}} !important',
					'{{WRAPPER}} .menu-item-has-children:hover' => 'border-bottom-color: {{VALUE}} !important',
					'{{WRAPPER}} .menu-header ul .mega .sub-menu li a::before' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .menu-header ul .mega .sub-menu li .sub-menu a::before' => 'background: #dfdfdf !important',
					'{{WRAPPER}} .dmega .sub-menu li:hover a' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .mega .sub-menu li .sub-menu li:hover a' => 'color: {{VALUE}} !important',
					
					/* css static color */
					
					'{{WRAPPER}} .dmega .sub-menu li:hover .sub-menu li a' => 'color: #111 !important',
					'{{WRAPPER}} .dmega .sub-menu li:hover .sub-menu li .sub-menu li a' => 'color: #666 !important',

					'{{WRAPPER}} #menucolornew43 .dmega .sub-menu li .sub-menu li .sub-menu li a' => 'color: #666 !important',

					'{{WRAPPER}} .menu-header .dmega .sub-menu .sub-menu li a::before' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .dmega .sub-menu .sub-menu li .sub-menu a::before' => 'background: #eee !important',
					'{{WRAPPER}} .dmega .sub-menu .sub-menu li .sub-menu li:hover a' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} #menucolornew43 .dmega .sub-menu .sub-menu li .sub-menu li:hover a' => 'color: {{VALUE}} !important',

				],
			]
           );
   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'پس زمینه منو های اصلی منو تب', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .dmega .sub-menu li' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .dmega .sub-menu li .sub-menu li ' => 'background: #fff !important',
					'{{WRAPPER}} .dmega .sub-menu li:hover:first-child' => 'background: #fff !important',
					'{{WRAPPER}} .dmega .sub-menu li:hover' => 'background: #fff !important',
					'{{WRAPPER}} .dmega .sub-menu li.lins:first-child ' => 'background: #fff !important',
					'{{WRAPPER}} #menucolornew43 .dmega .sub-menu:hover li:first-child' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} #menucolornew43 .dmega .sub-menu li:hover:first-child' => 'background: #fff !important',
					'{{WRAPPER}}  #menucolornew43 .dmega .sub-menu li:first-child:hover ' => 'background: #fff !important',
					'{{WRAPPER}}  #menucolornew43 .dmega .sub-menu li .sub-menu li ' => 'background: #fff !important',
					'{{WRAPPER}}  #menucolornew43 .dmega .sub-menu:hover li:first-child .sub-menu li ' => 'background: #fff !important',
					'{{WRAPPER}}  #menucolornew43 .dmega .sub-menu:hover .sub-menu li:first-child ' => 'background: #fff !important',

			
				],
			]
           );
		   
		   
		   
	   $this->add_control(
'color_farnam_342new1',
			[
				'label' => __( 'رنگ پس زمینه منو دسته بندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #menucolornew43 .dmega' => 'background: {{VALUE}}',
				

				],
			]
           );
		   
		   
		      $this->add_control(
'color_farnam_342new2',
			[
				'label' => __( 'رنگ ایکون منو دسته بندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #menucolornew43 .dmega::before' => 'color: {{VALUE}}',
				

				],
			]
           );
		   	  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی منو تب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .dmega .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					   	  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی مگا منو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mega .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					   	  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی منو معمولی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .menu-header .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px ;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}

protected function render() {
    $settings = $this->get_settings_for_display();

    // اگر مقدار فیلد menu_dropdown وجود داشته باشد
    if (!empty($settings['menu_dropdown'])) {
        $menu_id = $settings['menu_dropdown'];

        // نمایش فهرست منتخب با استفاده از wp_nav_menu داخل یک div
        if ($menu_id && is_nav_menu($menu_id)) {
            echo '<div class="menu-header header-two-menu-2 test" id="menucolornew43">';
            wp_nav_menu(array(
                'menu' => $menu_id,
                'menu_class' => '',  // کلاس 'dmega' برای منو اضافه شده است
                'container' => '',
            ));
            echo '</div>';

            // اضافه کردن کد jQuery
            echo '<script>
            jQuery(document).ready(function($){
                $(".dmega li").hover(
                     function(){ $(this).prev().addClass("dmega-radius") },
                     function(){ $(this).prev().removeClass("dmega-radius") }
                );
            });
            jQuery(document).ready(function($){
                $(".dmega").hover(
                     function(){ $(this).addClass("test-grey") },
                     function(){ $(this).removeClass("test-grey") }
                );
            });
            </script>';
        }
    }
}
}