<?php
namespace Elementor;

class iconfarnam extends Widget_Base {
	
	public function get_name() {
		return 'iconfarnam';
	}
	
	public function get_title() {
		return 'ایکون فرنام';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);



	
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);


	$this->add_control(
			'color45',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .koodak-cat-new-1-innermk-000' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_control(
			'color455',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .koodak-cat-new-1-innermk-000' => 'color: {{VALUE}} !important',
				],
			]
		);
		
				$this->add_control(
                        'titr-124444-44r464345rw',
                        [
                            'label' => __( 'سایه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow34',
				'selector' => '{{WRAPPER}} .koodak-cat-new-1-innermk-000',
			]
		);
			
   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .img-icon-mk-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

   $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .koodak-cat-new-1-innermk-000' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );


		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			<div class='img-icon-mk-402'
			";
					echo ' style="background: url(' . $settings['image']['url'] . ');">
';
echo "
			<div class='koodak-cat-new-1-innermk-000'>
			
	
		";
				?>
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
	
		<?php
		echo"
			
			</div>
			
			</div>
";
	

	}


	
	protected function _content_template() {

    }
	
	
}