<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class product100 extends Widget_Base {

    public function get_name() {
        return 'product100';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصولات عمودی', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
                        $this->add_control(
			'widget_title',
			[
				'label' => __( 'عنوان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'اسلایدر عمودی', 'plugin-domain' ),
				'placeholder' => __( 'متن خود را وارد کنید', 'plugin-domain' ),
			]
		);
      $this->add_control(
			'more',
			[
				'label' => __( 'عنوان دکمه بیشتر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'بیشتر', 'plugin-domain' ),
				'placeholder' => __( 'متن خود را وارد کنید', 'plugin-domain' ),
			]
		);
      $this->add_control(
			'link',
			[
				'label' => __( 'لینک محصولات بیشتر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#', 'plugin-domain' ),
				'placeholder' => __( 'یک لینک وارد کنید', 'plugin-domain' ),
			]
		);
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                   $this->end_controls_section();

		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش دکمه محصولات بیشتر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش آیکون', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
 $this->add_control(
                        'titr-12-3w',
                        [
                            'label' => __( 'رنگ پس زمینه اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					
						$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background2',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerhtre ',
			]
		);


		   
			   $this->add_control(
'color_farnam_212',
			[
				'label' => __( 'رنگ پس زمینه داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.gf-402-1' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .onvan-sdsdfgdsg-dertgrtt .icon-shop' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onvan-sdsdfgdsg-dertgrtt .icon-shop span::before' => 'color: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ عنوان اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .onvan-sdsdfgdsg-deertgrtt' => 'color: {{VALUE}} !important',
				],
			]
           );
		     $this->add_control(
'color_farnam_421',
			[
				'label' => __( 'رنگ پس زمینه دکمه محصولات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .more-amoodi' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_425',
			[
				'label' => __( 'رنگ متن دکمه محصولات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .more-amoodi' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ کادر عنوان اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .onvan-sdsdfgdsg-dertgrtt' => 'border-bottom-color: {{VALUE}} !important',
				],
			]
           );  
		   
		 	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ کادر سمت راست جعبه داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.gf-402-1' => 'border-right-color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .s9-box-1-offewdwerwer44r' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .s9-box-1-offewdwerwer44r' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	 	   $this->add_control(
'color_farnam_754',
			[
				'label' => __( 'رنگ پس زمینه دور تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sluder-3213-1imgsd' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   		      	   	 	   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ عنوان محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sluder-3213-1-boxsd h4' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   		   
		   		      	   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ پس زمینه قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-amoodi' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		         	   	 	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ متن قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-amoodi' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		          	   	 	   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ واحد پول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-amoodi .woocommerce-Price-currencySymbol' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		   	          	   	 	
     
		   
		   
		   
		      	   	 	   $this->add_control(
'color_farnam_18',
			[
				'label' => __( 'رنگ فلش های اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sooski1' => 'color: {{VALUE}} ',
				],
			]
           );  
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerhtre' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
 $this->add_responsive_control(
                        'farnamborde54r1',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ht-row.gf-402-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .onvan-sdsdfgdsg-dertgrtt .icon-shop' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دکمه محصولات بیشتر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .more-amoodi' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .s9-box-1-offewdwerwer44r' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
									  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sluder-3213-1imgsd' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .sluder-3213-1imgsde' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
  $this->add_responsive_control(
                        'farnamborde4r4',
                        [
                            'label' => esc_html__( 'گردی قیمت', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-amoodi' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	

$this->add_control(
                        'titr-124444-44r464345rw',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow34',
				'selector' => '{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerhtre',
			]
		);

$this->add_control(
                        'titr-124444-4214r464345rw',
                        [
                            'label' => __( 'سایه باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shado12w34',
				'selector' => '{{WRAPPER}} .ht-row.gf-402-1',
			]
		);

        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12sd';
        }else{
            $collumval = 'product-list-off-401aswsd swiper-slide';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-off-401aswsd swiper-slide';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-off-401aswsd swiper-slide';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl new-offer-401444545345fgteerhtre">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row gf-402-1">
			
<div class="onvan-sdsdfgdsg-dertgrtt"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<span class="icon-shop"><span class="path1"></span><span class="path2"></span><span class="path3"></span></span><?php } ?>
<div class="onvan-sdsdfgdsg-deertgrtt">

<?php echo '' . $settings['widget_title'] . ''; ?></div>

 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<a href="<?php echo '' . $settings['link'] . ''; ?>" class="more-amoodi">
<?php echo '' . $settings['more'] . ''; ?></a><?php } ?>
</div>
  <div class="swiper myswiperver swiper-initialized swiper-horizontal swiper-pointer-events swiper-rtl swiper-backface-hidden swiper-free-mode">
    <div class="swiper-wrapper">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
					<div class="slider-3213sd"><a href="<?php the_permalink(); ?>">
							<div class="slider-3213-1sd">
							
							<div class="sluder-3213-1imgsd">
							<div class="sluder-3213-1imgsde">	<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>		<?php global $product; if ( $product->is_on_sale() ) : ?>


<div class="s9-box-1-offewdwerwer44r">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>

</div>
	<?php
endif;
?><?php } ?>
							<?php the_post_thumbnail('woocommerce_thumbnail'); ?>										</div>	</div>
				<div class="sluder-3213-1-boxsd">

 <h4><?php the_title(); ?></h4>
<div class="price-amoodi">

<?php global $product; echo $product->get_price_html(); ?>

</div>
						</div></div>				</a>
		</div>
				



                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>
    <div class="swiper-button-next sooski1"></div>
    <div class="swiper-button-prev sooski1"></div>
	    <script>
    var swiper = new Swiper(".myswiperver", {
      slidesPerView: 4,
      spaceBetween: 0,
	  	      direction: "vertical",

       navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
	   breakpoints: {
        320: {
          slidesPerView: 2,
          spaceBetween: 0,
        },
        630: {
          slidesPerView: 4,
          spaceBetween: 0,
        },
        1024: {
          slidesPerView: 4,
          spaceBetween: 0,
        },
      },
   
    });
  </script>
   
        </div>  
        </div>  


        <?php

    }


}


