<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class peoducttab extends Widget_Base {

    public function get_name() {
        return 'peoducttab';
    }
    
    public function get_title() {
        return __( 'تب محصولات', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'sepid' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            
  $this->add_control(
			'code',
			[
				'label' => __( 'کد اختصاصی تب', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'tab54', 'plugin-domain' ),
				'placeholder' => __( 'مثلا : tab25', 'plugin-domain' ),
			]
		);
            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                     $this->add_control(
                'producttab',
                [
                    'label' => esc_html__( 'تب محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            

        $this->end_controls_section();


         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
	

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش رنگ ها', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش جعبه ویژه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
       $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش دکمه جزییات', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
  
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             



		$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن تب ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-tab-menus.tab.bjky66667 .tablinks' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه تب فعال', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tablinks.tablinkstab54.active' => 'background: {{VALUE}} !important',
				],
			]
           );
		      $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن تب فعال', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-tab-menus.tab.bjky66667  .tablinks.tablinkstab54.active' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan12rre' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	
		   		   	      $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan12rre' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
					 		   	      $this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1-box h3' => 'color: {{VALUE}} !important',
				],
			]
           );
			 		   	      $this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .div-box-jelve::before' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .div-box-jelve::after' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   					 		   	      $this->add_control(
'sepidcolor-10',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-new34534543retert del' => 'color: {{VALUE}} !important',
				],
			]
           );
		      					 		   	      $this->add_control(
'sepidcolor-11',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-new34534543retert ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-new34534543retert' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      					 		   	      $this->add_control(
'sepidcolor-12',
			[
				'label' => __( 'رنگ کادر جدا کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1 .paiin-box-401-tab' => 'border-top-color: {{VALUE}} !important',
				],
			]
           );
		   			 		   	      $this->add_control(
'sepidcolor-13',
			[
				'label' => __( 'رنگ متن دکمه جزییات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .l9ink-vorood-sho' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   			 		   	      $this->add_control(
'sepidcolor-14',
			[
				'label' => __( 'رنگ هاور متن دکمه جزییات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .l9ink-vorood-sho:hover' => 'color: {{VALUE}} !important',
				],
			]
           );

		   			 		   	      $this->add_control(
'sepidcolor-152',
			[
				'label' => __( 'رنگ المان پایین محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی تب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ht-tab-menus.tab.bjky66667 .tablinks' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		      $this->add_responsive_control(
                        'sepidborder2',
                        [
                            'label' => esc_html__( 'گردی کادر محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-product-tab-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		     $this->add_responsive_control(
                        'sepidborder3',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mizan12rre' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   $this->add_responsive_control(
                        'sepidborder5',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .post-block.m-product.ir99 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   
        $this->end_controls_section();

             


          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-listtab';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-listtab';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-listtab';
                }
            }
        }

        ?>
                  <?php if ( $producttab == 'yes' ) { ?>
		
                <div class="product-tab-list ht-text-center vbnmkti655656">
                    <ul class="ht-tab-menus tab bjky66667">
                        <?php
                            $m=0;
                            if( is_array( $product_cats ) && count( $product_cats ) > 0 ){

                                // Category retrive
                                $catargs = array(
                                    'orderby'    => 'name',
                                    'order'      => 'ASC',
                                    'hide_empty' => true,
                                    'slug'       => $product_cats,
                                );
                                $prod_categories = get_terms( 'product_cat', $catargs);

                                foreach( $prod_categories as $prod_cats ){
                                    $m++;
                                    $field_name = is_numeric( $product_cats[0] ) ? 'term_id' : 'slug';
                                    $args['tax_query'] = array(
                                        array(
                                            'taxonomy' => 'product_cat',
                                            'terms' => $prod_cats,
                                            'field' => $field_name,
                                            'include_children' => false
                                        ),
                                    );
                                    if( 'featured' == $product_type ){
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_visibility',
                                            'field'    => 'name',
                                            'terms'    => 'featured',
                                            'operator' => 'IN',
                                        );
                                    }
                                    $fetchproduct = new \WP_Query( $args );

                                    if( $fetchproduct->have_posts() ){
                                        ?>
										
										  <button class="tablinks tablinks<?php echo '' . $settings['code'] . ''; ?> <?php if($m==1){ echo 'active';}?>" onclick="openCity<?php echo '' . $settings['code'] . ''; ?>(event, 'sepidtab<?php echo $tabuniqid.esc_attr($m);?>')">                                                <?php echo esc_attr( $prod_cats->name,'woolentor' );?>
</button>
                                          
                                        <?php
                                    }
                                }
                            }
                        ?>
                    </ul>
                </div>
            <?php }; ?>
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
			
                    <div  class="sepid-ht-tab-pane sepid-ht-tab-pane<?php echo '' . $settings['code'] . ''; ?> <?php if($j==1){echo 'htactive';} ?>" id="<?php echo 'sepidtab'.$tabuniqid.$j;?>">
                        
                        <div class="ht-row ns-402-20">
                            <div class="<?php echo esc_attr( $collumval );?>">
                                <?php
                                    $k=1;
                                    while( $products->have_posts() ): $products->the_post();
                                ?>

 <div class="sepid-product-tab-1">

 <div class="sepid-product-tab-1-box">
 								<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

 <div class="rangbandi-style-1400">

<?php $option_meta = rwmb_meta('colorin1'); if (!empty($option_meta)) { ?>

<?php
    
    
$values = rwmb_meta("colorin1");
//print_r($values);
//if(!empty($values)){
    //print_r($values);
foreach ( $values as $value ) {
                    echo '<div class="rangi-dayere-342" style="background: ';
print_r( $value );	   
	
                    echo ';"></div>';

}
//}
?><?php } ?>
</div><?php } ?>
<a  href="<?php the_permalink(); ?>">

					<div class="img-bars-4012">
					
						<?php the_post_thumbnail('woocommerce_thumbnail'); ?>


					</div>
					</a><a  href="<?php the_permalink(); ?>">

						<div class="div-box-jelve"></div>


<h3><?php the_title(); ?></h3>
				<div class="price-new345345433rer">

					<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="mizan12rre">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo' , $product ); ?>


</div>	<?php } ?><div class="price-new34534543retert">
					<?php global $product;  echo $product->get_price_html(); ?></div>
					


				</div></a>
				
				<div class="paiin-box-401-tab">
								 								<?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>

				<a href="<?php the_permalink(); ?>" class="l9ink-vorood-sho">خرید و جزییات</a>
				<?php } ?>
				 								<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

				<div class="risk-meta hoversho-www1 ffgt544">
<div class="liningk fg455 bazsho1">
<div class="tooltiping">
علاقه مندی به محصول</div>
<?php echo do_shortcode("[yith_wcwl_add_to_wishlist]"); ?>
</div>
<span class="cpmare-wefew fg455 bazsho1">
<div class="tooltiping">
مقایسه این محصول</div>
<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</span>



</div><?php } ?>
</div>
</div></div>
                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval);?>">
                                <?php } $k++; endwhile; wp_reset_postdata(); ?>
                            </div>
                        </div>

                    </div>
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp">

     

  
                <div class="ht-row roozaye-barfi ns-402-20">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>

<div class="sepid-product-tab-1">

 <div class="sepid-product-tab-1-box">
 								<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

 <div class="rangbandi-style-1400">

<?php $option_meta = rwmb_meta('colorin1'); if (!empty($option_meta)) { ?>

<?php
    
    
$values = rwmb_meta("colorin1");
//print_r($values);
//if(!empty($values)){
    //print_r($values);
foreach ( $values as $value ) {
                    echo '<div class="rangi-dayere-342" style="background: ';
print_r( $value );	   
	
                    echo ';"></div>';

}
//}
?><?php } ?>
</div><?php } ?>
<a  href="<?php the_permalink(); ?>">

					<div class="img-bars-4012">
					
						<?php the_post_thumbnail('woocommerce_thumbnail'); ?>


					</div>
					</a>
						<div class="div-box-jelve"></div>

<a  href="<?php the_permalink(); ?>">

<h3><?php the_title(); ?></h3>
				<div class="price-new345345433rer">

					<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="mizan12rre">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo' , $product ); ?>


</div>	<?php } ?><div class="price-new34534543retert">
					<?php global $product;  echo $product->get_price_html(); ?></div>
					


				</div></a>
				
				<div class="paiin-box-401-tab">
								 								<?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>

				<a href="<?php the_permalink(); ?>" class="l9ink-vorood-sho">خرید و جزییات</a>
				<?php } ?>
				 								<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

				<div class="risk-meta hoversho-www1 ffgt544">
<div class="liningk fg455 bazsho1">
<div class="tooltiping">
علاقه مندی به محصول</div>
<?php echo do_shortcode("[yith_wcwl_add_to_wishlist]"); ?>
</div>
<span class="cpmare-wefew fg455 bazsho1">
<div class="tooltiping">
مقایسه این محصول</div>
<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</span>



</div><?php } ?>
</div>
</div></div>

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       
            <?php endif;?>

		<script>
					function openCity<?php echo '' . $settings['code'] . ''; ?>(evt, cityName<?php echo '' . $settings['code'] . ''; ?>) {
  // Declare all variables
  var i, sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>, tablinks<?php echo '' . $settings['code'] . ''; ?>;

  // Get all elements with class="sepidhttabpane" and hide them
  sepidhttabpane<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("sepid-ht-tab-pane<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>[i].style.display = "none";
  }

  // Get all elements with class="tablinks" and remove the class "active"
  tablinks<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("tablinks<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < tablinks<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className = tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className.replace(" active", "");
  }

  // Show the current tab, and add an "active" class to the button that opened the tab
  document.getElementById(cityName<?php echo '' . $settings['code'] . ''; ?>).style.display = "block";
  evt.currentTarget.className += " active";
} 
					</script>

        <?php

    }


}


