<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class product88 extends Widget_Base {

    public function get_name() {
        return 'product88';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصولات ۸', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
                           $this->add_control(
			'widget_title',
			[
				'label' => __( 'عنوان اصلی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'اسلایدر محصولات', 'plugin-domain' ),
				'placeholder' => __( 'متن خود را وارد کنید', 'plugin-domain' ),
			]
		);
                      $this->add_control(
			'widget_title1',
			[
				'label' => __( 'زیر عنوان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'محصولات حرفه ای', 'plugin-domain' ),
				'placeholder' => __( 'متن خود را وارد کنید', 'plugin-domain' ),
			]
		);
	$this->add_control(
			'image',
			[
				'label' => __( 'تصویر اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                   $this->end_controls_section();

		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش جعبه دسترسی سریع', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش افزودن به سبد خرید', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
 $this->add_control(
                        'titr-12-3w',
                        [
                            'label' => __( 'رنگ پس زمینه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					
						$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background2',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .ht-row.ns-402-197564::before ',
			]
		);


		   
	
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iconmk-000' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .iconmk-000' => 'color: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ عنوان اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mk-402-title-box' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mk-402-title-bo55x' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		 	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .left-box-402mk .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'پس زمینه اصلی محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .min-mahsool-mk-402' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ پس زمینه باکس داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .min-mahsool-mk-4023' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		   		      	   	 	   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ عنوان محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .min-mahsool-mk-4023-title' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   		   
		   		      	   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetert' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		         	   	 	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetert' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	          	   	 	   $this->add_control(
'color_farnam_12444',
			[
				'label' => __( 'رنگ پس زمینه قیمت تخفی فخورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-bottom-kjl0 del' => 'background: {{VALUE}} !important',
				],
			]
           );  
		          	   	 	   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ متن تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-bottom-kjl0 del' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		           	   	 	   $this->add_control(
'color_farnam_13',
			[
				'label' => __( 'رنگ متن اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-bottom-kjl0 ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-bottom-kjl0' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		
		   	          	   	 	   $this->add_control(
'color_farnam_14',
			[
				'label' => __( 'رنگ هاور دکمه ها', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654 .liningk.bazsho1:hover i' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654 .cpmare-wefew.bazsho1:hover .woosc p-btn::before' => 'color: {{VALUE}} !important',
				],
			]
           );  
		          	   	 	   $this->add_control(
'color_farnam_15',
			[
				'label' => __( 'رنگ پس زمینه افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button.loading' => 'background: {{VALUE}} !important',
										'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button.loading' => 'color: {{VALUE}} !important',
				],
			]
           );  
		     	 	   $this->add_control(
'color_farnam_145',
			[
				'label' => __( 'رنگ متن دکمه افزودن به سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		             	   	 	   $this->add_control(
'color_farnam_16',
			[
				'label' => __( 'رنگ افزودن به سبد خرید ( افزوده شده ) ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button.added' => 'background: {{VALUE}} !important',
				],
			]
           );  
		         	   	 	   $this->add_control(
'color_farnam_164',
			[
				'label' => __( 'رنگ متن افزودن به سبد خرید ( افزوده شده ) ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button.added' => 'color: {{VALUE}} !important',
				],
			]
           ); 
		   
		   	             	   	 	   $this->add_control(
'color_farnam_17',
			[
				'label' => __( 'رنگ کادر دکمه مشاهده سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .added_to_cart.wc-forward' => 'border-top-color: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_18',
			[
				'label' => __( 'رنگ دکمه مشاهده سبد خرید', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mifgdfg-34534 .added_to_cart.wc-forward' => 'color: {{VALUE}} ',
				],
			]
           );  
		   
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ht-row.ns-402-197564::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .iconmk-000' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .min-mahsool-mk-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .min-mahsool-mk-4023' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
					
					  $this->add_responsive_control(
                        'farnamborder46556',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .daroffer-sepid-mobilewertetert' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
						$this->add_responsive_control(
                        'farnamborder4655656',
                        [
                            'label' => esc_html__( 'گردی قیمت تخفیف خورده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-bottom-kjl0 del' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );				  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی دکمه افزودن به سبد خرید', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mifgdfg-34534 .button.add_to_cart_button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					

$this->add_control(
                        'titr-124444-44r464345rw',
                        [
                            'label' => __( 'سایه یاکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow34',
				'selector' => '{{WRAPPER}} .min-mahsool-mk-4023',
			]
		);

        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-off-401as';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-off-401as';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-off-401as';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl new-offer-401444545345">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row ns-402-197564">
                 <script>           $(document).ready(function(){
$('.owl-offer-new1254').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		   360:{
            items:2,
			        margin:0
        },
        1024:{
            items:3
        },
        1240:{
            items:4
        }
    }
})
});</script>


<div class="right-box-402mk">
<div class="icongerd-iran">

<div class="iconmk-000">

			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>

</div></div>
<div class="mk-402-title-box">
<?php echo '' . $settings['widget_title'] . ''; ?> </div>
<div class="mk-402-title-bo55x">
<?php echo '' . $settings['widget_title1'] . ''; ?> </div>
<div class="imgfa-mk98">
			<?php echo '<img src="' . $settings['image']['url'] . '">'; ?>
</div>

</div>
<div class="left-box-402mk">

   <div class="owl-offer-new1254 owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="min-mahsool-mk-40211">
<a href="<?php the_permalink(); ?>">
<div class="min-mahsool-mk-402">
<div class="min-mahsool-mk-4023">
<div class="min-mahsool-mk-4024">
<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
</div>

<div class="min-mahsool-mk-4023-title">

<?php the_title(); ?>

</div></div>
<div class="price-bottom-kjl0">
<?php global $product; echo $product->get_price_html(); ?>

</div>
<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

	<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="daroffer-sepid-mobilewertetert">
<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>

</div>
<?php } ?><?php } ?>
</div></a>
<div class="mifgdfg-34534"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<div class="risk-meta rthrth44444 mk-45645645645654">
<div class="liningk bazsho1">
<div class="tooltiping">
علاقه مندی به محصول</div>
<?php echo do_shortcode("[yith_wcwl_add_to_wishlist]"); ?>
</div>
<span class="cpmare-wefew bazsho1">
<div class="tooltiping">
مقایسه این محصول</div>
<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</span>







</div><?php } ?>
<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
	<?php

	do_action( 'woocommerce_after_shop_loop_item' );
	?><?php } ?>
</div>

</div>

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div></div>
            <?php endif;?>

        </div>  


        <?php

    }


}


