<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class product112 extends Widget_Base {

    public function get_name() {
        return 'product112';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصولات 11', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
                

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                   $this->end_controls_section();

		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش علاقه مندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش مقایسه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
 

		   
		    
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mr-402-box-product' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ پس زمینه باکس داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mini-product-add-to-crrra44rt-mr-tasvir' => 'background: {{VALUE}} !important',
				],
			]
           );

	
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ عنوان محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .min-mahsool-mk-4023-titlewslkjkj-mr-title' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
	
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );  
		      $this->add_control(
'color_farnam_37',
			[
				'label' => __( 'رنگ هاور پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}}.product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button:hover' => 'background: {{VALUE}} !important',
				],
			]
           );  $this->add_control(
'color_farnam_327',
			[
				'label' => __( 'رنگ هاور متن دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button:hover' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   		      	  
		   
		   		   
		   		      	   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		         	   	 	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		          	   	 	   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-mini-product-mr-price del' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		   	          	   	 	   $this->add_control(
'color_farnam_14',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-mini-product-mr-price' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-mini-product-mr-price ins' => 'color: {{VALUE}} !important',
				],
			]
           );  
		          		 	   $this->add_control(
'color_farnam_16',
			[
				'label' => __( 'رنگ پس زمینه علاقه مندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .add_to_wishlist.single_add_to_wishlist' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .yith-wcwl-wishlistaddedbrowse' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .yith-wcwl-wishlistexistsbrowse' => 'background: {{VALUE}} !important',
				],
			]
           );     	 	   
		   		 	   $this->add_control(
'color_farnam_17',
			[
				'label' => __( 'رنگ ایکون علاقه مندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .add_to_wishlist.single_add_to_wishlist' => 'color: {{VALUE}} !important',
				],
			]
           );     

   $this->add_control(
'color_farnam_18',
			[
				'label' => __( 'رنگ هاور ایکون علاقه مندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654 .liningk.bazsho1:hover i' => 'color: {{VALUE}} !important',
				],
			]
           );  

 $this->add_control(
'color_farnam_19',
			[
				'label' => __( 'رنگ هاور ایکون علاقه مندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654 .liningk.bazsho1:hover i' => 'color: {{VALUE}} !important',
				],
			]
           );    		

 $this->add_control(
'color_farnam_20',
			[
				'label' => __( 'رنگ پس زمینه مقایسه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .woosc p-btn' => 'background: {{VALUE}} !important',
				],
			]
           );   
  		    $this->add_control(
'color_farnam_21',
			[
				'label' => __( 'رنگ متن مقایسه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .woosc p-btn' => 'color: {{VALUE}} !important',
				],
			]
           );   
  		       $this->add_control(
'color_farnam_2321',
			[
				'label' => __( 'رنگ هاور متن مقایسه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654 .cpmare-wefew.bazsho1:hover .woosc p-btn::before' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .cpmare-wefew .woosc p-btn:hover' => 'color: {{VALUE}} !important',
				],
			]
           );   
		   	   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .mini-product-add-to-crrra44rt-mr-tasvir',
			]
		);
				
			
				
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mr-402-box-product' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-product-add-to-crrra44rt-mr-tasvir' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-product-add-to-crrra44rt-mr-tasvir img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
									  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					$this->add_responsive_control(
                        'farnamborder6',
                        [
                            'label' => esc_html__( 'گردی علاقه مندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .add_to_wishlist.single_add_to_wishlist' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .yith-wcwl-wishlistaddedbrowse' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .yith-wcwl-wishlistexistsbrowse' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					  $this->add_responsive_control(
                        'farnamborder7',
                        [
                            'label' => esc_html__( 'گردی مقایسه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .risk-meta.rthrth44444.mk-45645645645654.mr-402-87 .woosc p-btn' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	

        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-off-401aswhgmr402';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-off-401aswhgmr402';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-off-401aswhgmr402';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl new-offer-401444545345fgteerrrmr-402">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center4mr-402">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row ns-402-197564876-000mr-402">

			
	
                 <script>           $(document).ready(function(){
$('.owl-offer-new1254wmr').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		   360:{
            items:2,
			        margin:0
        },
        850:{
            items:3
        },
        1200:{
            items:5
        }
    }
})
});</script>


   <div class="owl-offer-new1254wmr owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
							
							
							<div class="mr-402-box-product">

														<div class="mr-402-box-product-1">
														<a href="<?php the_permalink(); ?>">
														<div class="mr-402-box-product-2">
<div class="min-mahsool-mk-4023-titlewslkjkj-mr-title">

<?php the_title(); ?>

</div>

<div class="price-mini-product-mr-price">

<?php global $product; echo $product->get_price_html(); ?>


</div>
							</div></a>
							
							<div class="mini-product-add-to-crrra44rt-mr-tasvir">
							<div class="risk-meta rthrth44444 mk-45645645645654 mr-402-87">
														<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<div class="liningk bazsho1">
<div class="tooltiping">
علاقه مندی به محصول</div>
<?php echo do_shortcode("[yith_wcwl_add_to_wishlist]"); ?>
</div><?php } ?>

<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
<span class="cpmare-wefew bazsho1">
<div class="tooltiping">
مقایسه این محصول</div>
<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</span>
<?php } ?>






</div>					
			<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

	<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="daroffer-sepid-mobilewertetertws-mr-402">
<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>

</div>
<?php } ?><?php } ?></a>
							</div>
							</div>
							</div>
				
							
							




                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>

        </div>  


        <?php

    }


}


