<?php
namespace Elementor;

class catone extends Widget_Base {
	
	public function get_name() {
		return 'catone';
	}
	
	public function get_title() {
		return 'دسته بندی 5';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);

				$this->add_control(
			'title1',
			[
				'label' => __( 'تعداد محصولات', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عدد وارد کنید', 'elementor' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'ادرس لینک را وارد کنید', 'elementor' ),
			]
		);



		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mehr-iran-65mr-402' => 'background: {{VALUE}} !important;',
				],
			]
		);
$this->add_control(
			'color1',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mehr-iran-65mr-402 h4' => 'color: {{VALUE}} !important;',
				],
			]
		);
$this->add_control(
			'color2',
			[
				'label' => __( 'رنگ المان کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mehr-iran-65mr-402 h4::before' => 'background: {{VALUE}} !important;',
				],
			]
		);

$this->add_control(
			'color3',
			[
				'label' => __( 'رنگ پس زمینه تعداد محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mr-402-5-tedad' => 'background: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'color4',
			[
				'label' => __( 'رنگ متن محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mr-402-5-tedad' => 'color: {{VALUE}} !important;',
				],
			]
		);
				$this->add_control(
			'color5',
			[
				'label' => __( 'رنگ متن تعداد محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mr-402-5-tedad strong' => 'color: {{VALUE}} !important;',
				],
			]
		);
   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mehr-iran-65mr-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

   $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mehr-iran-65mr-402 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

   $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی شمارنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mr-402-5-tedad' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );


		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<div class='mehrine-1mr-402'><a href='$settings[link]' class='mehr-iran-65mr-402'>
			<h4>$settings[title] </h4>		

			";
		
echo "
";
			echo '<img src="' . $settings['image']['url'] . '">
';


echo "
<div class='mr-402-5-tedad'>
<strong>
$settings[title1]</strong> محصول 
</div>

	</a></div>
		";
			

	

	}


	
	protected function _content_template() {

    }
	
	
}