<?php
namespace Elementor;

class blogseven extends Widget_Base {
	
	public function get_name() {
		return 'blogseven';
	}
	
	public function get_title() {
		return 'لیست مطالب جدید';
	}
	
		
    public function get_icon() {
		return 'eicon eicon-posts-group';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);


					

		$this->end_controls_section();
		
		
		$this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش دیدگاه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

        $this->end_controls_section();

	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		   
	
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه نوشته', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog2' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-2-img-farvardin-403-blog-img' => 'background: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ عنوان نوشته', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog2 .comment-title-402-4-farvardin-403-blog h4' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ پس زمینه دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .didgah-402-box-farvardin-403-blog' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		 	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .didgah-402-box-farvardin-403-blog' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ هاور پس زمینه دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog2:hover .didgah-402-box-farvardin-403-blog' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ هاور متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog2:hover .didgah-402-box-farvardin-403-blog' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   		      	   	 	   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ پس زمینه نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ پس زمینه تصویر نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2 .blog-new-402-2-img-farvardin-403-blog-img' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   		   
		   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ عنوان نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2 .comment-title-402-4-farvardin-403-blog h4' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   	$this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ پس زمینه دیدگاه نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2 .didgah-402-box-farvardin-403-blog' => 'background: {{VALUE}} !important',
				],
			]
           );  	
		   
		   
		   	   	$this->add_control(
'color_farnam_13',
			[
				'label' => __( 'رنگ متن دیدگاه نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2 .didgah-402-box-farvardin-403-blog' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   	   	$this->add_control(
'color_farnam_14',
			[
				'label' => __( 'رنگ هاور پس زمینه دیدگاه نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2:hover .didgah-402-box-farvardin-403-blog' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   $this->add_control(
'color_farnam_15',
			[
				'label' => __( 'رنگ هاور متن دیدگاه نوشته اول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-new-402-farvardin-403-blog:first-child .blog-new-402-farvardin-403-blog2:hover .didgah-402-box-farvardin-403-blog' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-new-402-farvardin-403-blog2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی تصویر نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-new-402-2-img-farvardin-403-blog-img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .blog-new-402-2-img-farvardin-403-blog-img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .didgah-402-box-farvardin-403-blog' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
				

        $this->end_controls_section();


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99 mkl-402-1">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>

		
		                   <div class="farvardin-403-blog-one-321">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
			
			
			<div class="blog-new-402-farvardin-403-blog">
			<div class="blog-new-402-farvardin-403-blog2">
			<a href="<?php the_permalink(); ?>">
			<div class="blog-new-4022-farvardin-403-blog">
			<div class="blog-new-402-2-img-farvardin-403-blog">
			<div class="blog-new-402-2-img-farvardin-403-blog-img">
			
				<?php the_post_thumbnail('thumbnail'); ?></div>
	
</div>


<div class="comment-title-402-4-farvardin-403-blog">
<h4><?php the_title(); ?></h4>	<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<div class="didgah-402-box-farvardin-403-blog">
<i class="fi fi-rr-comment"></i>
<?php comments_number( '0', ' 1 ', ' % ' ); ?>

</div><?php } ?>
</div>
			</a>
			</div></div></div>

			<?php endwhile; ?>
			
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
   		</div>	</div>
        <?php

	}

}